% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_realtime_contact_analysis_segments_v2}
\alias{connect_list_realtime_contact_analysis_segments_v2}
\title{Provides a list of analysis segments for a real-time analysis session}
\usage{
connect_list_realtime_contact_analysis_segments_v2(
  InstanceId,
  ContactId,
  MaxResults = NULL,
  NextToken = NULL,
  OutputType,
  SegmentTypes
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ContactId}{[required] The identifier of the contact in this instance of Amazon Connect.}

\item{MaxResults}{The maximum number of results to return per page.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{OutputType}{[required] The Contact Lens output type to be returned.}

\item{SegmentTypes}{[required] Enum with segment types . Each value corresponds to a segment type
returned in the segments list of the API. Each segment type has its own
structure. Different channels may have different sets of supported
segment types.}
}
\description{
Provides a list of analysis segments for a real-time analysis session.

See \url{https://www.paws-r-sdk.com/docs/connect_list_realtime_contact_analysis_segments_v2/} for full documentation.
}
\keyword{internal}
