% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_prompt}
\alias{connect_create_prompt}
\title{Creates a prompt}
\usage{
connect_create_prompt(InstanceId, Name, Description = NULL, S3Uri, Tags = NULL)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Name}{[required] The name of the prompt.}

\item{Description}{The description of the prompt.}

\item{S3Uri}{[required] The URI for the S3 bucket where the prompt is stored. You can provide S3
pre-signed URLs returned by the
\code{\link[=connect_get_prompt_file]{get_prompt_file}} API instead of providing S3
URIs.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}
}
\description{
Creates a prompt. For more information about prompts, such as supported file types and maximum length, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html}{Create prompts} in the \emph{Amazon Connect Administrator's Guide}.

See \url{https://www.paws-r-sdk.com/docs/connect_create_prompt/} for full documentation.
}
\keyword{internal}
