% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_evaluation_form}
\alias{connect_create_evaluation_form}
\title{Creates an evaluation form in the specified Amazon Connect instance}
\usage{
connect_create_evaluation_form(
  InstanceId,
  Title,
  Description = NULL,
  Items,
  ScoringStrategy = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Title}{[required] A title of the evaluation form.}

\item{Description}{The description of the evaluation form.}

\item{Items}{[required] Items that are part of the evaluation form. The total number of sections
and questions must not exceed 100 each. Questions must be contained in a
section.}

\item{ScoringStrategy}{A scoring strategy of the evaluation form.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.

See \url{https://www.paws-r-sdk.com/docs/connect_create_evaluation_form/} for full documentation.
}
\keyword{internal}
