% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectparticipant_operations.R
\name{connectparticipant_send_event}
\alias{connectparticipant_send_event}
\title{Sends an event}
\usage{
connectparticipant_send_event(
  ContentType,
  Content = NULL,
  ClientToken = NULL,
  ConnectionToken
)
}
\arguments{
\item{ContentType}{[required] The content type of the request. Supported types are:
\itemize{
\item application/vnd.amazonaws.connect.event.typing
\item application/vnd.amazonaws.connect.event.connection.acknowledged
\item application/vnd.amazonaws.connect.event.message.delivered
\item application/vnd.amazonaws.connect.event.message.read
}}

\item{Content}{The content of the event to be sent (for example, message text). For
content related to message receipts, this is supported in the form of a
JSON string.

Sample Content:
"\{\\"messageId\\":\\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\\"\}"}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ConnectionToken}{[required] The authentication token associated with the participant's connection.}
}
\description{
Sends an event.

See \url{https://www.paws-r-sdk.com/docs/connectparticipant_send_event/} for full documentation.
}
\keyword{internal}
