% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectparticipant_service.R
\name{connectparticipant}
\alias{connectparticipant}
\title{Amazon Connect Participant Service}
\usage{
connectparticipant(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Connect is an easy-to-use omnichannel cloud contact center
service that enables companies of any size to deliver superior customer
service at a lower cost. Amazon Connect communications capabilities make
it easy for companies to deliver personalized interactions across
communication channels, including chat.

Use the Amazon Connect Participant Service to manage participants (for
example, agents, customers, and managers listening in), and to send
messages and events within a chat contact. The APIs in the service
enable the following: sending chat messages, attachment sharing,
managing a participant's connection state and message events, and
retrieving chat transcripts.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- connectparticipant(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=connectparticipant_complete_attachment_upload]{complete_attachment_upload} \tab Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API\cr
\link[=connectparticipant_create_participant_connection]{create_participant_connection} \tab Creates the participant's connection\cr
\link[=connectparticipant_disconnect_participant]{disconnect_participant} \tab Disconnects a participant\cr
\link[=connectparticipant_get_attachment]{get_attachment} \tab Provides a pre-signed URL for download of a completed attachment\cr
\link[=connectparticipant_get_transcript]{get_transcript} \tab Retrieves a transcript of the session, including details about any attachments\cr
\link[=connectparticipant_send_event]{send_event} \tab Sends an event\cr
\link[=connectparticipant_send_message]{send_message} \tab Sends a message\cr
\link[=connectparticipant_start_attachment_upload]{start_attachment_upload} \tab Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3
}
}

\examples{
\dontrun{
svc <- connectparticipant()
svc$complete_attachment_upload(
  Foo = 123
)
}

}
