% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_create_custom_verification_email_template}
\alias{sesv2_create_custom_verification_email_template}
\title{Creates a new custom verification email template}
\usage{
sesv2_create_custom_verification_email_template(
  TemplateName,
  FromEmailAddress,
  TemplateSubject,
  TemplateContent,
  SuccessRedirectionURL,
  FailureRedirectionURL
)
}
\arguments{
\item{TemplateName}{[required] The name of the custom verification email template.}

\item{FromEmailAddress}{[required] The email address that the custom verification email is sent from.}

\item{TemplateSubject}{[required] The subject line of the custom verification email.}

\item{TemplateContent}{[required] The content of the custom verification email. The total size of the
email must be less than 10 MB. The message body may contain HTML, with
some limitations. For more information, see \href{https://docs.aws.amazon.com/ses/latest/dg/#custom-verification-emails-faq}{Custom Verification Email Frequently Asked Questions}
in the \emph{Amazon SES Developer Guide}.}

\item{SuccessRedirectionURL}{[required] The URL that the recipient of the verification email is sent to if his
or her address is successfully verified.}

\item{FailureRedirectionURL}{[required] The URL that the recipient of the verification email is sent to if his
or her address is not successfully verified.}
}
\description{
Creates a new custom verification email template.

See \url{https://paws-r.github.io/docs/sesv2/create_custom_verification_email_template.html} for full documentation.
}
\keyword{internal}
