% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_search_profiles}
\alias{customerprofiles_search_profiles}
\title{Searches for profiles within a specific domain name using name, phone
number, email address, account number, or a custom defined index}
\usage{
customerprofiles_search_profiles(
  NextToken = NULL,
  MaxResults = NULL,
  DomainName,
  KeyName,
  Values
)
}
\arguments{
\item{NextToken}{The pagination token from the previous SearchProfiles API call.}

\item{MaxResults}{The maximum number of objects returned per page.}

\item{DomainName}{[required] The unique name of the domain.}

\item{KeyName}{[required] A searchable identifier of a customer profile. The predefined keys you
can use to search include: _account, _profileId, _assetId, _caseId,
_orderId, _fullName, _phone, _email, _ctrContactId,
_marketoLeadId, _salesforceAccountId, _salesforceContactId,
_salesforceAssetId, _zendeskUserId, _zendeskExternalId,
_zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId,
_segmentUserId, _shopifyCustomerId, _shopifyOrderId.}

\item{Values}{[required] A list of key values.}
}
\description{
Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index.

See \url{https://paws-r.github.io/docs/customerprofiles/search_profiles.html} for full documentation.
}
\keyword{internal}
