% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_current_metric_data}
\alias{connect_get_current_metric_data}
\title{Gets the real-time metric data from the specified Amazon Connect
instance}
\usage{
connect_get_current_metric_data(
  InstanceId,
  Filters,
  Groupings = NULL,
  CurrentMetrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{Filters}{[required] The queues, up to 100, or channels, to use to filter the metrics
returned. Metric data is retrieved only for the resources associated
with the queues or channels included in the filter. You can include both
queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK
channels are supported.}

\item{Groupings}{The grouping applied to the metrics returned. For example, when grouped
by \code{QUEUE}, the metrics returned apply to each queue rather than
aggregated for all queues. If you group by \code{CHANNEL}, you should include
a Channels filter. VOICE, CHAT, and TASK channels are supported.

If no \code{Grouping} is included in the request, a summary of metrics is
returned.}

\item{CurrentMetrics}{[required] The metrics to retrieve. Specify the name and unit for each metric. The
following metrics are available. For a description of all the metrics,
see \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html}{Real-time Metrics Definitions}
in the \emph{Amazon Connect Administrator Guide}.

\strong{AGENTS_AFTER_CONTACT_WORK}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time}{ACW}

\strong{AGENTS_AVAILABLE}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time}{Available}

\strong{AGENTS_ERROR}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time}{Error}

\strong{AGENTS_NON_PRODUCTIVE}

Unit: COUNT

Name in real-time metrics report: \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time}{NPT (Non-Productive Time)}

\strong{AGENTS_ON_CALL}

Unit: COUNT

Name in real-time metrics report: \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time}{On contact}

\strong{AGENTS_ON_CONTACT}

Unit: COUNT

Name in real-time metrics report: \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time}{On contact}

\strong{AGENTS_ONLINE}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time}{Online}

\strong{AGENTS_STAFFED}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time}{Staffed}

\strong{CONTACTS_IN_QUEUE}

Unit: COUNT

Name in real-time metrics report: \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time}{In queue}

\strong{CONTACTS_SCHEDULED}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time}{Scheduled}

\strong{OLDEST_CONTACT_AGE}

Unit: SECONDS

When you use groupings, Unit says SECONDS and the Value is returned in
SECONDS.

When you do not use groupings, Unit says SECONDS but the Value is
returned in MILLISECONDS. For example, if you get a response like this:

\verb{\\\{ "Metric": \\\{ "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" \\\}, "Value": 24113.0 }\}

The actual OLDEST_CONTACT_AGE is 24 seconds.

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time}{Oldest}

\strong{SLOTS_ACTIVE}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time}{Active}

\strong{SLOTS_AVAILABLE}

Unit: COUNT

Name in real-time metrics report:
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time}{Availability}}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.

The token expires after 5 minutes from the time it is created.
Subsequent requests that use the token must use the same request
parameters as the request that generated the token.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets the real-time metric data from the specified Amazon Connect instance.

See \url{https://paws-r.github.io/docs/connect/get_current_metric_data.html} for full documentation.
}
\keyword{internal}
