% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_describe_receipt_rule_set}
\alias{ses_describe_receipt_rule_set}
\title{Returns the details of the specified receipt rule set}
\usage{
ses_describe_receipt_rule_set(RuleSetName)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set to describe.}
}
\description{
Returns the details of the specified receipt rule set.
}
\details{
For information about managing receipt rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$describe_receipt_rule_set(
  RuleSetName = "string"
)
}
}

\examples{
# The following example returns the metadata and receipt rules of a
# receipt rule set:
\donttest{svc$describe_receipt_rule_set(
  RuleSetName = "MyRuleSet"
)}

}
\keyword{internal}
