% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_delete_receipt_rule_set}
\alias{ses_delete_receipt_rule_set}
\title{Deletes the specified receipt rule set and all of the receipt rules it
contains}
\usage{
ses_delete_receipt_rule_set(RuleSetName)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set to delete.}
}
\description{
Deletes the specified receipt rule set and all of the receipt rules it
contains.
}
\details{
The currently active rule set cannot be deleted.

For information about managing receipt rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$delete_receipt_rule_set(
  RuleSetName = "string"
)
}
}

\examples{
# The following example deletes a receipt rule set:
\donttest{svc$delete_receipt_rule_set(
  RuleSetName = "MyRuleSet"
)}

}
\keyword{internal}
