% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_get_domain_statistics_report}
\alias{pinpointemail_get_domain_statistics_report}
\title{Retrieve inbox placement and engagement rates for the domains that you
use to send email}
\usage{
pinpointemail_get_domain_statistics_report(Domain, StartDate, EndDate)
}
\arguments{
\item{Domain}{[required] The domain that you want to obtain deliverability metrics for.}

\item{StartDate}{[required] The first day (in Unix time) that you want to obtain domain
deliverability metrics for.}

\item{EndDate}{[required] The last day (in Unix time) that you want to obtain domain
deliverability metrics for. The \code{EndDate} that you specify has to be
less than or equal to 30 days after the \code{StartDate}.}
}
\value{
A list with the following syntax:\preformatted{list(
  OverallVolume = list(
    VolumeStatistics = list(
      InboxRawCount = 123,
      SpamRawCount = 123,
      ProjectedInbox = 123,
      ProjectedSpam = 123
    ),
    ReadRatePercent = 123.0,
    DomainIspPlacements = list(
      list(
        IspName = "string",
        InboxRawCount = 123,
        SpamRawCount = 123,
        InboxPercentage = 123.0,
        SpamPercentage = 123.0
      )
    )
  ),
  DailyVolumes = list(
    list(
      StartDate = as.POSIXct(
        "2015-01-01"
      ),
      VolumeStatistics = list(
        InboxRawCount = 123,
        SpamRawCount = 123,
        ProjectedInbox = 123,
        ProjectedSpam = 123
      ),
      DomainIspPlacements = list(
        list(
          IspName = "string",
          InboxRawCount = 123,
          SpamRawCount = 123,
          InboxPercentage = 123.0,
          SpamPercentage = 123.0
        )
      )
    )
  )
)
}
}
\description{
Retrieve inbox placement and engagement rates for the domains that you
use to send email.
}
\section{Request syntax}{
\preformatted{svc$get_domain_statistics_report(
  Domain = "string",
  StartDate = as.POSIXct(
    "2015-01-01"
  ),
  EndDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
