% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_tag_resource}
\alias{connect_tag_resource}
\title{Adds the specified tags to the specified resource}
\usage{
connect_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource.}

\item{tags}{[required] One or more tags. For example, \{ "tags": \{"key1":"value1",
"key2":"value2"\} \}.}
}
\value{
An empty list.
}
\description{
Adds the specified tags to the specified resource.

The supported resource types are users, routing profiles, quick
connects, and contact flows.

For sample policies that use tags, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html}{Amazon Connect Identity-Based Policy Examples}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  resourceArn = "string",
  tags = list(
    "string"
  )
)
}
}

\keyword{internal}
