% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_describe_contact_flow}
\alias{connect_describe_contact_flow}
\title{Describes the specified contact flow}
\usage{
connect_describe_contact_flow(InstanceId, ContactFlowId)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactFlowId}{[required] The identifier of the contact flow.}
}
\value{
A list with the following syntax:\preformatted{list(
  ContactFlow = list(
    Arn = "string",
    Id = "string",
    Name = "string",
    Type = "CONTACT_FLOW"|"CUSTOMER_QUEUE"|"CUSTOMER_HOLD"|"CUSTOMER_WHISPER"|"AGENT_HOLD"|"AGENT_WHISPER"|"OUTBOUND_WHISPER"|"AGENT_TRANSFER"|"QUEUE_TRANSFER",
    Description = "string",
    Content = "string",
    Tags = list(
      "string"
    )
  )
)
}
}
\description{
Describes the specified contact flow.

You can also create and update contact flows using the \href{https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html}{Amazon Connect Flow language}.
}
\section{Request syntax}{
\preformatted{svc$describe_contact_flow(
  InstanceId = "string",
  ContactFlowId = "string"
)
}
}

\keyword{internal}
