# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Marketplace Commerce Analytics
#'
#' @description
#' Provides AWS Marketplace business intelligence data on-demand.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- marketplacecommerceanalytics(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- marketplacecommerceanalytics()
#' svc$generate_data_set(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=marketplacecommerceanalytics_generate_data_set]{generate_data_set} \tab Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified S3 bucket and notifies the specified SNS topic once the data is available\cr
#'  \link[=marketplacecommerceanalytics_start_support_data_export]{start_support_data_export} \tab This target has been deprecated
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname marketplacecommerceanalytics
#' @export
marketplacecommerceanalytics <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .marketplacecommerceanalytics$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.marketplacecommerceanalytics <- list()

.marketplacecommerceanalytics$operations <- list()

.marketplacecommerceanalytics$metadata <- list(
  service_name = "marketplacecommerceanalytics",
  endpoints = list("*" = list(endpoint = "marketplacecommerceanalytics.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "marketplacecommerceanalytics.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "marketplacecommerceanalytics.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "marketplacecommerceanalytics.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "marketplacecommerceanalytics.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "marketplacecommerceanalytics.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Marketplace Commerce Analytics",
  api_version = "2015-07-01",
  signing_name = "marketplacecommerceanalytics",
  json_version = "1.1",
  target_prefix = "MarketplaceCommerceAnalytics20150701"
)

.marketplacecommerceanalytics$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.marketplacecommerceanalytics$metadata, handlers, config)
}
