% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_update_cost_category_definition}
\alias{costexplorer_update_cost_category_definition}
\title{Updates an existing Cost Category}
\usage{
costexplorer_update_cost_category_definition(
  CostCategoryArn,
  EffectiveStart = NULL,
  RuleVersion,
  Rules,
  DefaultValue = NULL,
  SplitChargeRules = NULL
)
}
\arguments{
\item{CostCategoryArn}{[required] The unique identifier for your Cost Category.}

\item{EffectiveStart}{The Cost Category's effective start date. It can only be a billing start
date (first day of the month). If the date isn't provided, it's the
first day of the current month. Dates can't be before the previous
twelve months, or in the future.}

\item{RuleVersion}{[required]}

\item{Rules}{[required] The \code{Expression} object used to categorize costs. For more information,
see
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html}{CostCategoryRule}
.}

\item{DefaultValue}{}

\item{SplitChargeRules}{The split charge rules used to allocate your charges between your Cost
Category values.}
}
\description{
Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_update_cost_category_definition/} for full documentation.
}
\keyword{internal}
