% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_cost_categories}
\alias{costexplorer_get_cost_categories}
\title{Retrieves an array of Cost Category names and values incurred cost}
\usage{
costexplorer_get_cost_categories(
  SearchString = NULL,
  TimePeriod,
  CostCategoryName = NULL,
  Filter = NULL,
  SortBy = NULL,
  MaxResults = NULL,
  NextPageToken = NULL
)
}
\arguments{
\item{SearchString}{The value that you want to search the filter values for.

If you don't specify a \code{CostCategoryName}, \code{SearchString} is used to
filter Cost Category names that match the \code{SearchString} pattern. If you
specify a \code{CostCategoryName}, \code{SearchString} is used to filter Cost
Category values that match the \code{SearchString} pattern.}

\item{TimePeriod}{[required]}

\item{CostCategoryName}{}

\item{Filter}{}

\item{SortBy}{The value that you sort the data by.

The key represents the cost and usage metrics. The following values are
supported:
\itemize{
\item \code{BlendedCost}
\item \code{UnblendedCost}
\item \code{AmortizedCost}
\item \code{NetAmortizedCost}
\item \code{NetUnblendedCost}
\item \code{UsageQuantity}
\item \code{NormalizedUsageAmount}
}

The supported key values for the \code{SortOrder} value are \code{ASCENDING} and
\code{DESCENDING}.

When you use the \code{SortBy} value, the \code{NextPageToken} and \code{SearchString}
key values aren't supported.}

\item{MaxResults}{This field is only used when the \code{SortBy} value is provided in the
request.

The maximum number of objects that are returned for this request. If
\code{MaxResults} isn't specified with the \code{SortBy} value, the request
returns 1000 results as the default value for this parameter.

For \code{\link[=costexplorer_get_cost_categories]{get_cost_categories}},
MaxResults has an upper quota of 1000.}

\item{NextPageToken}{If the number of objects that are still available for retrieval exceeds
the quota, Amazon Web Services returns a NextPageToken value in the
response. To retrieve the next batch of objects, provide the
NextPageToken from the previous call in your next request.}
}
\description{
Retrieves an array of Cost Category names and values incurred cost.

See \url{https://paws-r.github.io/docs/costexplorer/get_cost_categories.html} for full documentation.
}
\keyword{internal}
