% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_list_custom_line_items}
\alias{billingconductor_list_custom_line_items}
\title{A paginated call to get a list of all custom line items (FFLIs) for the
given billing period}
\usage{
billingconductor_list_custom_line_items(
  BillingPeriod = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL
)
}
\arguments{
\item{BillingPeriod}{The preferred billing period to get custom line items (FFLIs).}

\item{MaxResults}{The maximum number of billing groups to retrieve.}

\item{NextToken}{The pagination token used on subsequent calls to get custom line items
(FFLIs).}

\item{Filters}{A \code{ListCustomLineItemsFilter} that specifies the custom line item names
and/or billing group Amazon Resource Names (ARNs) to retrieve FFLI
information.}
}
\description{
A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.

See \url{https://paws-r.github.io/docs/billingconductor/list_custom_line_items.html} for full documentation.
}
\keyword{internal}
