% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecommerceanalytics_operations.R
\name{marketplacecommerceanalytics_generate_data_set}
\alias{marketplacecommerceanalytics_generate_data_set}
\title{Given a data set type and data set publication date, asynchronously
publishes the requested data set to the specified S3 bucket and notifies
the specified SNS topic once the data is available}
\usage{
marketplacecommerceanalytics_generate_data_set(dataSetType,
  dataSetPublicationDate, roleNameArn, destinationS3BucketName,
  destinationS3Prefix, snsTopicArn, customerDefinedValues)
}
\arguments{
\item{dataSetType}{[required] The desired data set type.
\itemize{
\item \strong{customer\\_subscriber\\_hourly\\_monthly\\_subscriptions}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{customer\\_subscriber\\_annual\\_subscriptions}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_usage\\_by\\_instance\\_type}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_fees}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_free\\_trial\\_conversions}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_new\\_instances}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_new\\_product\\_subscribers}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{daily\\_business\\_canceled\\_product\\_subscribers}

From 2017-09-15 to present: Available daily by 24:00 UTC.
\item \strong{monthly\\_revenue\\_billing\\_and\\_revenue\\_data}

From 2017-09-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC. Data includes metered transactions (e.g. hourly)
from one month prior.
\item \strong{monthly\\_revenue\\_annual\\_subscriptions}

From 2017-09-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC. Data includes up-front software charges (e.g.
annual) from one month prior.
\item \strong{monthly\\_revenue\\_field\\_demonstration\\_usage}

From 2018-03-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC.
\item \strong{monthly\\_revenue\\_flexible\\_payment\\_schedule}

From 2018-11-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_product}

From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_instance\\_hours}

From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_customer\\_geo}

From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_age\\_of\\_uncollected\\_funds}

From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_age\\_of\\_disbursed\\_funds}

From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_age\\_of\\_past\\_due\\_funds}

From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
\item \strong{disbursed\\_amount\\_by\\_uncollected\\_funds\\_breakdown}

From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
\item \strong{sales\\_compensation\\_billed\\_revenue}

From 2017-09-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC. Data includes metered transactions (e.g. hourly)
from one month prior, and up-front software charges (e.g. annual)
from one month prior.
\item \strong{us\\_sales\\_and\\_use\\_tax\\_records}

From 2017-09-15 to present: Available monthly on the 15th day of the
month by 24:00 UTC.
}}

\item{dataSetPublicationDate}{[required] The date a data set was published. For daily data sets, provide a date with day-level granularity for the desired day. For monthly data sets except those with prefix disbursed_amount, provide a date with month-level granularity for the desired month (the day value will be ignored). For data sets with prefix disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we will look backwards in time over the range of 31 days until the first data set is found (the latest one).}

\item{roleNameArn}{[required] The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS services.}

\item{destinationS3BucketName}{[required] The name (friendly name, not ARN) of the destination S3 bucket.}

\item{destinationS3Prefix}{(Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3 bucket root.}

\item{snsTopicArn}{[required] Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an error has occurred.}

\item{customerDefinedValues}{(Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the data set metadata file. These key-value pairs can be used to correlated responses with tracking information from other systems.}
}
\description{
Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be published in comma-separated values (CSV) format with the file name \{data_set_type\}_YYYY-MM-DD.csv. If a file with the same name already exists (e.g. if the same data set is requested twice), the original file will be overwritten by the new file. Requires a Role with an attached permissions policy providing Allow permissions for the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.
}
\section{Request syntax}{
\preformatted{svc$generate_data_set(
  dataSetType = "customer_subscriber_hourly_monthly_subscriptions"|"customer_subscriber_annual_subscriptions"|"daily_business_usage_by_instance_type"|"daily_business_fees"|"daily_business_free_trial_conversions"|"daily_business_new_instances"|"daily_business_new_product_subscribers"|"daily_business_canceled_product_subscribers"|"monthly_revenue_billing_and_revenue_data"|"monthly_revenue_annual_subscriptions"|"monthly_revenue_field_demonstration_usage"|"monthly_revenue_flexible_payment_schedule"|"disbursed_amount_by_product"|"disbursed_amount_by_product_with_uncollected_funds"|"disbursed_amount_by_instance_hours"|"disbursed_amount_by_customer_geo"|"disbursed_amount_by_age_of_uncollected_funds"|"disbursed_amount_by_age_of_disbursed_funds"|"disbursed_amount_by_age_of_past_due_funds"|"disbursed_amount_by_uncollected_funds_breakdown"|"customer_profile_by_industry"|"customer_profile_by_revenue"|"customer_profile_by_geography"|"sales_compensation_billed_revenue"|"us_sales_and_use_tax_records",
  dataSetPublicationDate = as.POSIXct(
    "2015-01-01"
  ),
  roleNameArn = "string",
  destinationS3BucketName = "string",
  destinationS3Prefix = "string",
  snsTopicArn = "string",
  customerDefinedValues = list(
    "string"
  )
)
}
}

\keyword{internal}
