% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costandusagereportservice_service.R
\name{costandusagereportservice}
\alias{costandusagereportservice}
\title{AWS Cost and Usage Report Service}
\usage{
costandusagereportservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The AWS Cost and Usage Report API enables you to programmatically
create, query, and delete AWS Cost and Usage report definitions.

AWS Cost and Usage reports track the monthly AWS costs and usage
associated with your AWS account. The report contains line items for
each unique combination of AWS product, usage type, and operation that
your AWS account uses. You can configure the AWS Cost and Usage report
to show only the data that you want, using the AWS Cost and Usage API.

Service Endpoint

The AWS Cost and Usage Report API provides the following endpoint:
\itemize{
\item cur.us-east-1.amazonaws.com
}
}
\section{Service syntax}{
\preformatted{svc <- costandusagereportservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=costandusagereportservice_delete_report_definition]{delete_report_definition} \tab Deletes the specified report \cr
\link[=costandusagereportservice_describe_report_definitions]{describe_report_definitions} \tab Lists the AWS Cost and Usage reports available to this account\cr
\link[=costandusagereportservice_modify_report_definition]{modify_report_definition} \tab Allows you to programatically update your report preferences \cr
\link[=costandusagereportservice_put_report_definition]{put_report_definition} \tab Creates a new report using the description that you provide
}
}

\examples{
# The following example deletes the AWS Cost and Usage report named
# ExampleReport.
\donttest{svc <- costandusagereportservice()
svc$delete_report_definition(
  ReportName = "ExampleReport"
)}

}
