% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_delete_subscriber}
\alias{budgets_delete_subscriber}
\title{Deletes a subscriber}
\usage{
budgets_delete_subscriber(AccountId, BudgetName, Notification,
  Subscriber)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget whose subscriber you
want to delete.}

\item{BudgetName}{[required] The name of the budget whose subscriber you want to delete.}

\item{Notification}{[required] The notification whose subscriber you want to delete.}

\item{Subscriber}{[required] The subscriber that you want to delete.}
}
\description{
Deletes a subscriber.
}
\details{
Deleting the last subscriber to a notification also deletes the
notification.
}
\section{Request syntax}{
\preformatted{svc$delete_subscriber(
  AccountId = "string",
  BudgetName = "string",
  Notification = list(
    NotificationType = "ACTUAL"|"FORECASTED",
    ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
    Threshold = 123.0,
    ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
    NotificationState = "OK"|"ALARM"
  ),
  Subscriber = list(
    SubscriptionType = "SNS"|"EMAIL",
    Address = "string"
  )
)
}
}

\keyword{internal}
