# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Marketplace Entitlement Service
#'
#' @description
#' This reference provides descriptions of the AWS Marketplace Entitlement
#' Service API.
#' 
#' AWS Marketplace Entitlement Service is used to determine the entitlement
#' of a customer to a given product. An entitlement represents capacity in
#' a product owned by the customer. For example, a customer might own some
#' number of users or seats in an SaaS application or some amount of data
#' capacity in a multi-tenant database.
#' 
#' **Getting Entitlement Records**
#' 
#' -   *GetEntitlements*- Gets the entitlements for a Marketplace product.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- marketplaceentitlementservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- marketplaceentitlementservice()
#' svc$get_entitlements(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=marketplaceentitlementservice_get_entitlements]{get_entitlements} \tab GetEntitlements retrieves entitlement values for a given product
#' }
#'
#' @rdname marketplaceentitlementservice
#' @export
marketplaceentitlementservice <- function(config = list()) {
  svc <- .marketplaceentitlementservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.marketplaceentitlementservice <- list()

.marketplaceentitlementservice$operations <- list()

.marketplaceentitlementservice$metadata <- list(
  service_name = "entitlement.marketplace",
  endpoints = list("*" = list(endpoint = "entitlement.marketplace.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "entitlement.marketplace.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Marketplace Entitlement Service",
  api_version = "2017-01-11",
  signing_name = "aws-marketplace",
  json_version = "1.1",
  target_prefix = "AWSMPEntitlementService"
)

.marketplaceentitlementservice$handlers <- new_handlers("jsonrpc", "v4")

.marketplaceentitlementservice$service <- function(config = list()) {
  new_service(.marketplaceentitlementservice$metadata, .marketplaceentitlementservice$handlers, config)
}
