% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_reservation_coverage}
\alias{costexplorer_get_reservation_coverage}
\title{Retrieves the reservation coverage for your account}
\usage{
costexplorer_get_reservation_coverage(TimePeriod, GroupBy, Granularity,
  Filter, Metrics, NextPageToken)
}
\arguments{
\item{TimePeriod}{[required] The start and end dates of the period that you want to retrieve data
about reservation coverage for. You can retrieve data for a maximum of
13 months: the last 12 months and the current month. The start date is
inclusive, but the end date is exclusive. For example, if \code{start} is
\code{2017-01-01} and \code{end} is \code{2017-05-01}, then the cost and usage data is
retrieved from \code{2017-01-01} up to and including \code{2017-04-30} but not
including \code{2017-05-01}.}

\item{GroupBy}{You can group the data by the following attributes:
\itemize{
\item AZ
\item CACHE\_ENGINE
\item DATABASE\_ENGINE
\item DEPLOYMENT\_OPTION
\item INSTANCE\_TYPE
\item LINKED\_ACCOUNT
\item OPERATING\_SYSTEM
\item PLATFORM
\item REGION
\item TENANCY
}}

\item{Granularity}{The granularity of the AWS cost data for the reservation. Valid values
are \code{MONTHLY} and \code{DAILY}.

If \code{GroupBy} is set, \code{Granularity} can't be set. If \code{Granularity}
isn't set, the response object doesn't include \code{Granularity}, either
\code{MONTHLY} or \code{DAILY}.

The \code{GetReservationCoverage} operation supports only \code{DAILY} and
\code{MONTHLY} granularities.}

\item{Filter}{Filters utilization data by dimensions. You can filter by the following
dimensions:
\itemize{
\item AZ
\item CACHE\_ENGINE
\item DATABASE\_ENGINE
\item DEPLOYMENT\_OPTION
\item INSTANCE\_TYPE
\item LINKED\_ACCOUNT
\item OPERATING\_SYSTEM
\item PLATFORM
\item REGION
\item SERVICE
\item TAG
\item TENANCY
}

\code{GetReservationCoverage} uses the same
\href{http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}
object as the other operations, but only \code{AND} is supported among each
dimension. You can nest only one level deep. If there are multiple
values for a dimension, they are OR'd together.

If you don't provide a \code{SERVICE} filter, Cost Explorer defaults to EC2.}

\item{Metrics}{The measurement that you want your reservation coverage reported in.

Valid values are \code{Hour}, \code{Unit}, and \code{Cost}. You can use multiple values
in a request.}

\item{NextPageToken}{The token to retrieve the next set of results. AWS provides the token
when the response from a previous call has more results than the maximum
page size.}
}
\description{
Retrieves the reservation coverage for your account. This enables you to
see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache,
Amazon Relational Database Service, or Amazon Redshift usage is covered
by a reservation. An organization's master account can see the coverage
of the associated member accounts. For any time period, you can filter
data about reservation usage by the following dimensions:
}
\details{
\itemize{
\item AZ
\item CACHE\_ENGINE
\item DATABASE\_ENGINE
\item DEPLOYMENT\_OPTION
\item INSTANCE\_TYPE
\item LINKED\_ACCOUNT
\item OPERATING\_SYSTEM
\item PLATFORM
\item REGION
\item SERVICE
\item TAG
\item TENANCY
}

To determine valid values for a dimension, use the \code{GetDimensionValues}
operation.
}
\section{Request syntax}{
\preformatted{svc$get_reservation_coverage(
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  GroupBy = list(
    list(
      Type = "DIMENSION"|"TAG",
      Key = "string"
    )
  ),
  Granularity = "DAILY"|"MONTHLY"|"HOURLY",
  Filter = list(
    Or = list(
      list()
    ),
    And = list(
      list()
    ),
    Not = list(),
    Dimensions = list(
      Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID",
      Values = list(
        "string"
      )
    ),
    Tags = list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  Metrics = list(
    "string"
  ),
  NextPageToken = "string"
)
}
}

\keyword{internal}
