% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_function_concurrency}
\alias{lambda_put_function_concurrency}
\title{Sets the maximum number of simultaneous executions for a function, and
reserves capacity for that concurrency level}
\usage{
lambda_put_function_concurrency(FunctionName, ReservedConcurrentExecutions)
}
\arguments{
\item{FunctionName}{[required] The name or ARN of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{ReservedConcurrentExecutions}{[required] The number of simultaneous executions to reserve for the function.}
}
\description{
Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.

See \url{https://www.paws-r-sdk.com/docs/lambda_put_function_concurrency/} for full documentation.
}
\keyword{internal}
