% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_list_virtual_clusters}
\alias{emrcontainers_list_virtual_clusters}
\title{Lists information about the specified virtual cluster}
\usage{
emrcontainers_list_virtual_clusters(
  containerProviderId = NULL,
  containerProviderType = NULL,
  createdAfter = NULL,
  createdBefore = NULL,
  states = NULL,
  maxResults = NULL,
  nextToken = NULL,
  eksAccessEntryIntegrated = NULL
)
}
\arguments{
\item{containerProviderId}{The container provider ID of the virtual cluster.}

\item{containerProviderType}{The container provider type of the virtual cluster. Amazon EKS is the
only supported type as of now.}

\item{createdAfter}{The date and time after which the virtual clusters are created.}

\item{createdBefore}{The date and time before which the virtual clusters are created.}

\item{states}{The states of the requested virtual clusters.}

\item{maxResults}{The maximum number of virtual clusters that can be listed.}

\item{nextToken}{The token for the next set of virtual clusters to return.}

\item{eksAccessEntryIntegrated}{Optional Boolean that specifies whether the operation should return the
virtual clusters that have the access entry integration enabled or
disabled. If not specified, the operation returns all applicable virtual
clusters.}
}
\description{
Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.

See \url{https://www.paws-r-sdk.com/docs/emrcontainers_list_virtual_clusters/} for full documentation.
}
\keyword{internal}
