% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_associated_ipv_6_pool_cidrs}
\alias{ec2_get_associated_ipv_6_pool_cidrs}
\title{Gets information about the IPv6 CIDR block associations for a specified
IPv6 address pool}
\usage{
ec2_get_associated_ipv_6_pool_cidrs(
  PoolId,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL
)
}
\arguments{
\item{PoolId}{[required] The ID of the IPv6 address pool.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_associated_ipv_6_pool_cidrs/} for full documentation.
}
\keyword{internal}
