% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_set_repository_policy}
\alias{ecr_set_repository_policy}
\title{Applies a repository policy to the specified repository to control
access permissions}
\usage{
ecr_set_repository_policy(
  registryId = NULL,
  repositoryName,
  policyText,
  force = NULL
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry that
contains the repository. If you do not specify a registry, the default
registry is assumed.}

\item{repositoryName}{[required] The name of the repository to receive the policy.}

\item{policyText}{[required] The JSON repository policy text to apply to the repository. For more
information, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html}{Amazon ECR repository policies}
in the \emph{Amazon Elastic Container Registry User Guide}.}

\item{force}{If the policy you are attempting to set on a repository policy would
prevent you from setting another policy in the future, you must force
the \code{\link[=ecr_set_repository_policy]{set_repository_policy}} operation. This
is intended to prevent accidental repository lock outs.}
}
\description{
Applies a repository policy to the specified repository to control access permissions. For more information, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html}{Amazon ECR Repository policies} in the \emph{Amazon Elastic Container Registry User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ecr_set_repository_policy/} for full documentation.
}
\keyword{internal}
