% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_verified_access_group_policy}
\alias{ec2_modify_verified_access_group_policy}
\title{Modifies the specified Amazon Web Services Verified Access group policy}
\usage{
ec2_modify_verified_access_group_policy(
  VerifiedAccessGroupId,
  PolicyEnabled = NULL,
  PolicyDocument = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  SseSpecification = NULL
)
}
\arguments{
\item{VerifiedAccessGroupId}{[required] The ID of the Verified Access group.}

\item{PolicyEnabled}{The status of the Verified Access policy.}

\item{PolicyDocument}{The Verified Access policy document.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SseSpecification}{The options for server side encryption.}
}
\description{
Modifies the specified Amazon Web Services Verified Access group policy.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_verified_access_group_policy/} for full documentation.
}
\keyword{internal}
