% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_connect_endpoints}
\alias{ec2_describe_instance_connect_endpoints}
\title{Describes the specified EC2 Instance Connect Endpoints or all EC2
Instance Connect Endpoints}
\usage{
ec2_describe_instance_connect_endpoints(
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL,
  InstanceConnectEndpointIds = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{Filters}{One or more filters.
\itemize{
\item \code{instance-connect-endpoint-id} - The ID of the EC2 Instance Connect
Endpoint.
\item \code{state} - The state of the EC2 Instance Connect Endpoint
(\verb{create-in-progress} | \code{create-complete} | \code{create-failed} |
\verb{delete-in-progress} | \code{delete-complete} | \code{delete-failed}).
\item \code{subnet-id} - The ID of the subnet in which the EC2 Instance Connect
Endpoint was created.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{tag-value} - The value of a tag assigned to the resource. Use this
filter to find all resources that have a tag with a specific value,
regardless of tag key.
\item \code{vpc-id} - The ID of the VPC in which the EC2 Instance Connect
Endpoint was created.
}}

\item{InstanceConnectEndpointIds}{One or more EC2 Instance Connect Endpoint IDs.}
}
\description{
Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect Endpoints.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_instance_connect_endpoints/} for full documentation.
}
\keyword{internal}
