% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_event_window}
\alias{ec2_modify_instance_event_window}
\title{Modifies the specified event window}
\usage{
ec2_modify_instance_event_window(
  DryRun = NULL,
  Name = NULL,
  InstanceEventWindowId,
  TimeRanges = NULL,
  CronExpression = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Name}{The name of the event window.}

\item{InstanceEventWindowId}{[required] The ID of the event window.}

\item{TimeRanges}{The time ranges of the event window.}

\item{CronExpression}{The cron expression of the event window, for example,
\verb{* 0-4,20-23 * * 1,5}.

Constraints:
\itemize{
\item Only hour and day of the week values are supported.
\item For day of the week values, you can specify either integers \code{0}
through \code{6}, or alternative single values \code{SUN} through \code{SAT}.
\item The minute, month, and year must be specified by \code{*}.
\item The hour value must be one or a multiple range, for example, \code{0-4}
or \verb{0-4,20-23}.
\item Each hour range must be \>= 2 hours, for example, \code{0-2} or \code{20-23}.
\item The event window must be \>= 4 hours. The combined total time ranges
in the event window must be \>= 4 hours.
}

For more information about cron expressions, see
\href{https://en.wikipedia.org/wiki/Cron}{cron} on the \emph{Wikipedia website}.}
}
\description{
Modifies the specified event window.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_event_window/} for full documentation.
}
\keyword{internal}
