% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_stale_security_groups}
\alias{ec2_describe_stale_security_groups}
\title{Describes the stale security group rules for security groups in a
specified VPC}
\usage{
ec2_describe_stale_security_groups(
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  VpcId
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{VpcId}{[required] The ID of the VPC.}
}
\description{
Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in the same VPC, peered VPC, or in separate VPCs attached to a transit gateway (with \href{https://docs.aws.amazon.com/vpc/latest/tgw/tgw-transit-gateways.html#create-tgw}{security group referencing support} enabled). Rules can also be stale if they reference a security group in a peer VPC for which the VPC peering connection has been deleted or if they reference a security group in a VPC that has been detached from a transit gateway.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_stale_security_groups/} for full documentation.
}
\keyword{internal}
