% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fast_snapshot_restores}
\alias{ec2_describe_fast_snapshot_restores}
\title{Describes the state of fast snapshot restores for your snapshots}
\usage{
ec2_describe_fast_snapshot_restores(
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Filters}{The filters. The possible values are:
\itemize{
\item \code{availability-zone}: The Availability Zone of the snapshot.
\item \code{owner-id}: The ID of the Amazon Web Services account that enabled
fast snapshot restore on the snapshot.
\item \code{snapshot-id}: The ID of the snapshot.
\item \code{state}: The state of fast snapshot restores for the snapshot
(\code{enabling} | \code{optimizing} | \code{enabled} | \code{disabling} | \code{disabled}).
}}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the state of fast snapshot restores for your snapshots.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_fast_snapshot_restores/} for full documentation.
}
\keyword{internal}
