% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_delete_function_url_config}
\alias{lambda_delete_function_url_config}
\title{Deletes a Lambda function URL}
\usage{
lambda_delete_function_url_config(FunctionName, Qualifier = NULL)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Qualifier}{The alias name.}
}
\description{
Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL results in a different URL address.

See \url{https://www.paws-r-sdk.com/docs/lambda_delete_function_url_config/} for full documentation.
}
\keyword{internal}
