% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_import_component}
\alias{imagebuilder_import_component}
\title{Imports a component and transforms its data into a component document}
\usage{
imagebuilder_import_component(
  name,
  semanticVersion,
  description = NULL,
  changeDescription = NULL,
  type,
  format,
  platform,
  data = NULL,
  uri = NULL,
  kmsKeyId = NULL,
  tags = NULL,
  clientToken
)
}
\arguments{
\item{name}{[required] The name of the component.}

\item{semanticVersion}{[required] The semantic version of the component. This version follows the semantic
version syntax.

The semantic version has four nodes:
\<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
first three, and can filter on all of them.

\strong{Filtering:} With semantic versioning, you have the flexibility to use
wildcards (x) to specify the most recent versions or nodes when
selecting the base image or components for your recipe. When you use a
wildcard in any node, all nodes to the right of the first wildcard must
also be wildcards.}

\item{description}{The description of the component. Describes the contents of the
component.}

\item{changeDescription}{The change description of the component. This description indicates the
change that has been made in this version, or what makes this version
different from other versions of this component.}

\item{type}{[required] The type of the component denotes whether the component is used to build
the image, or only to test it.}

\item{format}{[required] The format of the resource that you want to import as a component.}

\item{platform}{[required] The platform of the component.}

\item{data}{The data of the component. Used to specify the data inline. Either
\code{data} or \code{uri} can be used to specify the data within the component.}

\item{uri}{The uri of the component. Must be an Amazon S3 URL and the requester
must have permission to access the Amazon S3 bucket. If you use Amazon
S3, you can specify component content up to your service quota. Either
\code{data} or \code{uri} can be used to specify the data within the component.}

\item{kmsKeyId}{The ID of the KMS key that should be used to encrypt this component.}

\item{tags}{The tags of the component.}

\item{clientToken}{[required] The idempotency token of the component.}
}
\description{
Imports a component and transforms its data into a component document.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_import_component/} for full documentation.
}
\keyword{internal}
