% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_local_gateway_route}
\alias{ec2_delete_local_gateway_route}
\title{Deletes the specified route from the specified local gateway route table}
\usage{
ec2_delete_local_gateway_route(
  DestinationCidrBlock = NULL,
  LocalGatewayRouteTableId,
  DryRun = NULL,
  DestinationPrefixListId = NULL
)
}
\arguments{
\item{DestinationCidrBlock}{The CIDR range for the route. This must match the CIDR for the route
exactly.}

\item{LocalGatewayRouteTableId}{[required] The ID of the local gateway route table.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{DestinationPrefixListId}{Use a prefix list in place of \code{DestinationCidrBlock}. You cannot use
\code{DestinationPrefixListId} and \code{DestinationCidrBlock} in the same
request.}
}
\description{
Deletes the specified route from the specified local gateway route table.

See \url{https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route/} for full documentation.
}
\keyword{internal}
