% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_attribute}
\alias{ec2_modify_vpc_attribute}
\title{Modifies the specified attribute of the specified VPC}
\usage{
ec2_modify_vpc_attribute(
  EnableDnsHostnames = NULL,
  EnableDnsSupport = NULL,
  VpcId,
  EnableNetworkAddressUsageMetrics = NULL
)
}
\arguments{
\item{EnableDnsHostnames}{Indicates whether the instances launched in the VPC get DNS hostnames.
If enabled, instances in the VPC get DNS hostnames; otherwise, they do
not.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute. You can only
enable DNS hostnames if you've enabled DNS support.}

\item{EnableDnsSupport}{Indicates whether the DNS resolution is supported for the VPC. If
enabled, queries to the Amazon provided DNS server at the
169.254.169.253 IP address, or the reserved IP address at the base of
the VPC network range "plus two" succeed. If disabled, the Amazon
provided DNS service in the VPC that resolves public DNS hostnames to IP
addresses is not enabled.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute.}

\item{VpcId}{[required] The ID of the VPC.}

\item{EnableNetworkAddressUsageMetrics}{Indicates whether Network Address Usage metrics are enabled for your
VPC.}
}
\description{
Modifies the specified attribute of the specified VPC.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_vpc_attribute/} for full documentation.
}
\keyword{internal}
