% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_network_interface_attribute}
\alias{ec2_modify_network_interface_attribute}
\title{Modifies the specified network interface attribute}
\usage{
ec2_modify_network_interface_attribute(
  Attachment = NULL,
  Description = NULL,
  DryRun = NULL,
  Groups = NULL,
  NetworkInterfaceId,
  SourceDestCheck = NULL,
  EnaSrdSpecification = NULL
)
}
\arguments{
\item{Attachment}{Information about the interface attachment. If modifying the
\verb{delete on termination} attribute, you must specify the ID of the
interface attachment.}

\item{Description}{A description for the network interface.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Groups}{Changes the security groups for the network interface. The new set of
groups you specify replaces the current set. You must specify at least
one group, even if it's just the default security group in the VPC. You
must specify the ID of the security group, not the name.}

\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{SourceDestCheck}{Enable or disable source/destination checks, which ensure that the
instance is either the source or the destination of any traffic that it
receives. If the value is \code{true}, source/destination checks are enabled;
otherwise, they are disabled. The default value is \code{true}. You must
disable source/destination checks if the instance runs services such as
network address translation, routing, or firewalls.}

\item{EnaSrdSpecification}{Updates the ENA Express configuration for the network interface that’s
attached to the instance.}
}
\description{
Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_network_interface_attribute/} for full documentation.
}
\keyword{internal}
