% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_environment}
\alias{proton_create_environment}
\title{Deploy a new environment}
\usage{
proton_create_environment(
  componentRoleArn = NULL,
  description = NULL,
  environmentAccountConnectionId = NULL,
  name,
  protonServiceRoleArn = NULL,
  provisioningRepository = NULL,
  spec,
  tags = NULL,
  templateMajorVersion,
  templateMinorVersion = NULL,
  templateName
)
}
\arguments{
\item{componentRoleArn}{The Amazon Resource Name (ARN) of the IAM service role that Proton uses
when provisioning directly defined components in this environment. It
determines the scope of infrastructure that a component can provision.

You must specify \code{componentRoleArn} to allow directly defined components
to be associated with this environment.

For more information about components, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html}{Proton components}
in the \emph{Proton Administrator Guide}.}

\item{description}{A description of the environment that's being created and deployed.}

\item{environmentAccountConnectionId}{The ID of the environment account connection that you provide if you're
provisioning your environment infrastructure resources to an environment
account. For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html}{Environment account connections}
in the \emph{Proton Administrator guide}.

To use Amazon Web Services-managed provisioning for the environment,
specify either the \code{environmentAccountConnectionId} or
\code{protonServiceRoleArn} parameter and omit the \code{provisioningRepository}
parameter.}

\item{name}{[required] The name of the environment.}

\item{protonServiceRoleArn}{The Amazon Resource Name (ARN) of the Proton service role that allows
Proton to make calls to other services on your behalf.

To use Amazon Web Services-managed provisioning for the environment,
specify either the \code{environmentAccountConnectionId} or
\code{protonServiceRoleArn} parameter and omit the \code{provisioningRepository}
parameter.}

\item{provisioningRepository}{The infrastructure repository that you use to host your rendered
infrastructure templates for self-managed provisioning.

To use self-managed provisioning for the environment, specify this
parameter and omit the \code{environmentAccountConnectionId} and
\code{protonServiceRoleArn} parameters.}

\item{spec}{[required] A YAML formatted string that provides inputs as defined in the
environment template bundle schema file. For more information, see
\href{https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html}{Environments}
in the \emph{Proton Administrator Guide}.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton environment. A tag is a key-value pair.

For more information, see \emph{Proton resources and tagging} in the \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton Administrator Guide}
or \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton User Guide}.}

\item{templateMajorVersion}{[required] The major version of the environment template.}

\item{templateMinorVersion}{The minor version of the environment template.}

\item{templateName}{[required] The name of the environment template. For more information, see
\href{https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html}{Environment Templates}
in the \emph{Proton Administrator Guide}.}
}
\description{
Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.

See \url{https://paws-r.github.io/docs/proton/create_environment.html} for full documentation.
}
\keyword{internal}
