% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_reset_instance_attribute}
\alias{ec2_reset_instance_attribute}
\title{Resets an attribute of an instance to its default value}
\usage{
ec2_reset_instance_attribute(Attribute, DryRun = NULL, InstanceId)
}
\arguments{
\item{Attribute}{[required] The attribute to reset.

You can only reset the following attributes: \code{kernel} | \code{ramdisk} |
\code{sourceDestCheck}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}
}
\description{
Resets an attribute of an instance to its default value. To reset the \code{kernel} or \code{ramdisk}, the instance must be in a stopped state. To reset the \code{sourceDestCheck}, the instance can be either running or stopped.

See \url{https://paws-r.github.io/docs/ec2/reset_instance_attribute.html} for full documentation.
}
\keyword{internal}
