% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_managed_prefix_list_associations}
\alias{ec2_get_managed_prefix_list_associations}
\title{Gets information about the resources that are associated with the
specified managed prefix list}
\usage{
ec2_get_managed_prefix_list_associations(
  DryRun = NULL,
  PrefixListId,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PrefixListId}{[required] The ID of the prefix list.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Gets information about the resources that are associated with the specified managed prefix list.

See \url{https://paws-r.github.io/docs/ec2/get_managed_prefix_list_associations.html} for full documentation.
}
\keyword{internal}
