% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_attribute}
\alias{ec2_describe_instance_attribute}
\title{Describes the specified attribute of the specified instance}
\usage{
ec2_describe_instance_attribute(Attribute, DryRun = NULL, InstanceId)
}
\arguments{
\item{Attribute}{[required] The instance attribute.

Note: The \code{enaSupport} attribute is not supported at this time.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}
}
\description{
Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: \code{instanceType} | \code{kernel} | \code{ramdisk} | \code{userData} | \code{disableApiTermination} | \code{instanceInitiatedShutdownBehavior} | \code{rootDeviceName} | \code{blockDeviceMapping} | \code{productCodes} | \code{sourceDestCheck} | \code{groupSet} | \code{ebsOptimized} | \code{sriovNetSupport}

See \url{https://paws-r.github.io/docs/ec2/describe_instance_attribute.html} for full documentation.
}
\keyword{internal}
