% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_dhcp_options}
\alias{ec2_create_dhcp_options}
\title{Creates a set of DHCP options for your VPC}
\usage{
ec2_create_dhcp_options(
  DhcpConfigurations,
  TagSpecifications = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DhcpConfigurations}{[required] A DHCP configuration option.}

\item{TagSpecifications}{The tags to assign to the DHCP option.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see \href{https://www.ietf.org/rfc/rfc2132.txt}{RFC 2132}.

See \url{https://paws-r.github.io/docs/ec2/create_dhcp_options.html} for full documentation.
}
\keyword{internal}
