% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_revoke_security_group_ingress}
\alias{ec2_revoke_security_group_ingress}
\title{Removes the specified ingress rules from a security group}
\usage{
ec2_revoke_security_group_ingress(CidrIp, FromPort, GroupId, GroupName,
  IpPermissions, IpProtocol, SourceSecurityGroupName,
  SourceSecurityGroupOwnerId, ToPort, DryRun)
}
\arguments{
\item{CidrIp}{The CIDR IP address range. You can\'t specify this parameter when
specifying a source security group.}

\item{FromPort}{The start of port range for the TCP and UDP protocols, or an ICMP type
number. For the ICMP type number, use \code{-1} to specify all ICMP types.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request.}

\item{IpPermissions}{The sets of IP permissions. You can\'t specify a source security group
and a CIDR IP address range in the same set of permissions.}

\item{IpProtocol}{The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}).
Use \code{-1} to specify all.}

\item{SourceSecurityGroupName}{[EC2-Classic, default VPC] The name of the source security group. You
can\'t specify this parameter in combination with the following
parameters: the CIDR IP address range, the start of the port range, the
IP protocol, and the end of the port range. For EC2-VPC, the source
security group must be in the same VPC. To revoke a specific rule for an
IP protocol and port range, use a set of IP permissions instead.}

\item{SourceSecurityGroupOwnerId}{[EC2-Classic] The AWS account ID of the source security group, if the
source security group is in a different account. You can\'t specify this
parameter in combination with the following parameters: the CIDR IP
address range, the IP protocol, the start of the port range, and the end
of the port range. To revoke a specific rule for an IP protocol and port
range, use a set of IP permissions instead.}

\item{ToPort}{The end of port range for the TCP and UDP protocols, or an ICMP code
number. For the ICMP code number, use \code{-1} to specify all ICMP codes for
the ICMP type.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Removes the specified ingress rules from a security group. To remove a
rule, the values that you specify (for example, ports) must match the
existing rule\'s values exactly.
}
\details{
[EC2-Classic only] If the values you specify do not match the existing
rule\'s values, no error is returned. Use DescribeSecurityGroups to
verify that the rule has been removed.

Each rule consists of the protocol and the CIDR range or source security
group. For the TCP and UDP protocols, you must also specify the
destination port or range of ports. For the ICMP protocol, you must also
specify the ICMP type and code. If the security group rule has a
description, you do not have to specify the description to revoke the
rule.

Rule changes are propagated to instances within the security group as
quickly as possible. However, a small delay might occur.
}
\section{Request syntax}{
\preformatted{svc$revoke_security_group_ingress(
  CidrIp = "string",
  FromPort = 123,
  GroupId = "string",
  GroupName = "string",
  IpPermissions = list(
    list(
      FromPort = 123,
      IpProtocol = "string",
      IpRanges = list(
        list(
          CidrIp = "string",
          Description = "string"
        )
      ),
      Ipv6Ranges = list(
        list(
          CidrIpv6 = "string",
          Description = "string"
        )
      ),
      PrefixListIds = list(
        list(
          Description = "string",
          PrefixListId = "string"
        )
      ),
      ToPort = 123,
      UserIdGroupPairs = list(
        list(
          Description = "string",
          GroupId = "string",
          GroupName = "string",
          PeeringStatus = "string",
          UserId = "string",
          VpcId = "string",
          VpcPeeringConnectionId = "string"
        )
      )
    )
  ),
  IpProtocol = "string",
  SourceSecurityGroupName = "string",
  SourceSecurityGroupOwnerId = "string",
  ToPort = 123,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
