% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_image_attribute}
\alias{ec2_modify_image_attribute}
\title{Modifies the specified attribute of the specified AMI}
\usage{
ec2_modify_image_attribute(Attribute, Description, ImageId,
  LaunchPermission, OperationType, ProductCodes, UserGroups, UserIds,
  Value, DryRun)
}
\arguments{
\item{Attribute}{The name of the attribute to modify. The valid values are \code{description},
\code{launchPermission}, and \code{productCodes}.}

\item{Description}{A new description for the AMI.}

\item{ImageId}{[required] The ID of the AMI.}

\item{LaunchPermission}{A new launch permission for the AMI.}

\item{OperationType}{The operation type. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{ProductCodes}{The DevPay product codes. After you add a product code to an AMI, it
can\'t be removed.}

\item{UserGroups}{The user groups. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{UserIds}{The AWS account IDs. This parameter can be used only when the
\code{Attribute} parameter is \code{launchPermission}.}

\item{Value}{The value of the attribute being modified. This parameter can be used
only when the \code{Attribute} parameter is \code{description} or \code{productCodes}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the specified attribute of the specified AMI. You can specify
only one attribute at a time. You can use the \code{Attribute} parameter to
specify the attribute or one of the following parameters: \code{Description},
\code{LaunchPermission}, or \code{ProductCode}.
}
\details{
AWS Marketplace product codes cannot be modified. Images with an AWS
Marketplace product code cannot be made public.

To enable the SriovNetSupport enhanced networking attribute of an image,
enable SriovNetSupport on an instance and create an AMI from the
instance.
}
\section{Request syntax}{
\preformatted{svc$modify_image_attribute(
  Attribute = "string",
  Description = list(
    Value = "string"
  ),
  ImageId = "string",
  LaunchPermission = list(
    Add = list(
      list(
        Group = "all",
        UserId = "string"
      )
    ),
    Remove = list(
      list(
        Group = "all",
        UserId = "string"
      )
    )
  ),
  OperationType = "add"|"remove",
  ProductCodes = list(
    "string"
  ),
  UserGroups = list(
    "string"
  ),
  UserIds = list(
    "string"
  ),
  Value = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example makes the specified AMI public.
svc$modify_image_attribute(
  ImageId = "ami-5731123e",
  LaunchPermission = list(
    Add = list(
      list(
        Group = "all"
      )
    )
  )
)

# This example grants launch permissions for the specified AMI to the
# specified AWS account.
svc$modify_image_attribute(
  ImageId = "ami-5731123e",
  LaunchPermission = list(
    Add = list(
      list(
        UserId = "123456789012"
      )
    )
  )
)
}

}
\keyword{internal}
