% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_route}
\alias{ec2_create_route}
\title{Creates a route in a route table within a VPC}
\usage{
ec2_create_route(DestinationCidrBlock, DestinationIpv6CidrBlock,
  DestinationPrefixListId, DryRun, EgressOnlyInternetGatewayId, GatewayId,
  InstanceId, NatGatewayId, TransitGatewayId, LocalGatewayId,
  NetworkInterfaceId, RouteTableId, VpcPeeringConnectionId)
}
\arguments{
\item{DestinationCidrBlock}{The IPv4 CIDR address block used for the destination match. Routing
decisions are based on the most specific match. We modify the specified
CIDR block to its canonical form; for example, if you specify
\verb{100.68.0.18/18}, we modify it to \verb{100.68.0.0/18}.}

\item{DestinationIpv6CidrBlock}{The IPv6 CIDR block used for the destination match. Routing decisions
are based on the most specific match.}

\item{DestinationPrefixListId}{The ID of a prefix list used for the destination match.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EgressOnlyInternetGatewayId}{[IPv6 traffic only] The ID of an egress-only internet gateway.}

\item{GatewayId}{The ID of an internet gateway or virtual private gateway attached to
your VPC.}

\item{InstanceId}{The ID of a NAT instance in your VPC. The operation fails if you specify
an instance ID unless exactly one network interface is attached.}

\item{NatGatewayId}{[IPv4 traffic only] The ID of a NAT gateway.}

\item{TransitGatewayId}{The ID of a transit gateway.}

\item{LocalGatewayId}{The ID of the local gateway.}

\item{NetworkInterfaceId}{The ID of a network interface.}

\item{RouteTableId}{[required] The ID of the route table for the route.}

\item{VpcPeeringConnectionId}{The ID of a VPC peering connection.}
}
\description{
Creates a route in a route table within a VPC.
}
\details{
You must specify one of the following targets: internet gateway or
virtual private gateway, NAT instance, NAT gateway, VPC peering
connection, network interface, egress-only internet gateway, or transit
gateway.

When determining how to route traffic, we use the route with the most
specific match. For example, traffic is destined for the IPv4 address
\verb{192.0.2.3}, and the route table includes the following two IPv4 routes:
\itemize{
\item \verb{192.0.2.0/24} (goes to some target A)
\item \verb{192.0.2.0/28} (goes to some target B)
}

Both routes apply to the traffic destined for \verb{192.0.2.3}. However, the
second route in the list covers a smaller number of IP addresses and is
therefore more specific, so we use that route to determine where to
target the traffic.

For more information about route tables, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html}{Route Tables}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_route(
  DestinationCidrBlock = "string",
  DestinationIpv6CidrBlock = "string",
  DestinationPrefixListId = "string",
  DryRun = TRUE|FALSE,
  EgressOnlyInternetGatewayId = "string",
  GatewayId = "string",
  InstanceId = "string",
  NatGatewayId = "string",
  TransitGatewayId = "string",
  LocalGatewayId = "string",
  NetworkInterfaceId = "string",
  RouteTableId = "string",
  VpcPeeringConnectionId = "string"
)
}
}

\examples{
\dontrun{
# This example creates a route for the specified route table. The route
# matches all traffic (0.0.0.0/0) and routes it to the specified Internet
# gateway.
svc$create_route(
  DestinationCidrBlock = "0.0.0.0/0",
  GatewayId = "igw-c0a643a9",
  RouteTableId = "rtb-22574640"
)
}

}
\keyword{internal}
