% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_provisioned_concurrency_configs}
\alias{lambda_list_provisioned_concurrency_configs}
\title{Retrieves a list of provisioned concurrency configurations for a
function}
\usage{
lambda_list_provisioned_concurrency_configs(FunctionName, Marker,
  MaxItems)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Marker}{Specify the pagination token that\'s returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{Specify a number to limit the number of configurations returned.}
}
\description{
Retrieves a list of provisioned concurrency configurations for a
function.
}
\section{Request syntax}{
\preformatted{svc$list_provisioned_concurrency_configs(
  FunctionName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
