% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_describe_cluster}
\alias{eks_describe_cluster}
\title{Returns descriptive information about an Amazon EKS cluster}
\usage{
eks_describe_cluster(name)
}
\arguments{
\item{name}{[required] The name of the cluster to describe.}
}
\description{
Returns descriptive information about an Amazon EKS cluster.
}
\details{
The API server endpoint and certificate authority data returned by this
operation are required for \code{kubelet} and \code{kubectl} to communicate with
your Kubernetes API server. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html}{Create a kubeconfig for Amazon EKS}.

The API server endpoint and certificate authority data aren\'t available
until the cluster reaches the \code{ACTIVE} state.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster(
  name = "string"
)
}
}

\examples{
\dontrun{
# This example command provides a description of the specified cluster in
# your default region.
svc$describe_cluster(
  name = "devel"
)
}

}
\keyword{internal}
