% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_fpga_image}
\alias{ec2_copy_fpga_image}
\title{Copies the specified Amazon FPGA Image (AFI) to the current Region}
\usage{
ec2_copy_fpga_image(DryRun, SourceFpgaImageId, Description, Name,
  SourceRegion, ClientToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SourceFpgaImageId}{[required] The ID of the source AFI.}

\item{Description}{The description for the new AFI.}

\item{Name}{The name for the new AFI. The default is the name of the source AFI.}

\item{SourceRegion}{[required] The Region that contains the source AFI.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}
}
\description{
Copies the specified Amazon FPGA Image (AFI) to the current Region.
}
\section{Request syntax}{
\preformatted{svc$copy_fpga_image(
  DryRun = TRUE|FALSE,
  SourceFpgaImageId = "string",
  Description = "string",
  Name = "string",
  SourceRegion = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
