% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_metric_data}
\alias{lightsail_get_relational_database_metric_data}
\title{Returns the data points of the specified metric for a database in Amazon
Lightsail}
\usage{
lightsail_get_relational_database_metric_data(relationalDatabaseName,
  metricName, period, startTime, endTime, unit, statistics)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of your database from which to get metric data.}

\item{metricName}{[required] The name of the metric data to return.}

\item{period}{[required] The granularity, in seconds, of the returned data points.}

\item{startTime}{[required] The start of the time interval from which to get metric data.

Constraints:
\itemize{
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you wish to use a start time of October 1, 2018, at
8 PM UTC, then you input \code{1538424000} as the start time.
}}

\item{endTime}{[required] The end of the time interval from which to get metric data.

Constraints:
\itemize{
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you wish to use an end time of October 1, 2018, at 8
PM UTC, then you input \code{1538424000} as the end time.
}}

\item{unit}{[required] The unit for the metric data request.}

\item{statistics}{[required] The array of statistics for your metric data request.}
}
\description{
Returns the data points of the specified metric for a database in Amazon
Lightsail.
}
\section{Request syntax}{
\preformatted{svc$get_relational_database_metric_data(
  relationalDatabaseName = "string",
  metricName = "CPUUtilization"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput",
  period = 123,
  startTime = as.POSIXct(
    "2015-01-01"
  ),
  endTime = as.POSIXct(
    "2015-01-01"
  ),
  unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
  statistics = list(
    "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
  )
)
}
}

\keyword{internal}
