% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_monitor_instances}
\alias{ec2_monitor_instances}
\title{Enables detailed monitoring for a running instance}
\usage{
ec2_monitor_instances(InstanceIds, DryRun)
}
\arguments{
\item{InstanceIds}{[required] The IDs of the instances.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables detailed monitoring for a running instance. Otherwise, basic
monitoring is enabled. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html}{Monitoring Your Instances and Volumes}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\details{
To disable detailed monitoring, see .
}
\section{Request syntax}{
\preformatted{svc$monitor_instances(
  InstanceIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
