% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_clusters}
\alias{ecs_list_clusters}
\title{Returns a list of existing clusters}
\usage{
ecs_list_clusters(nextToken, maxResults)
}
\arguments{
\item{nextToken}{The \code{nextToken} value returned from a \code{ListClusters} request indicating
that more results are available to fulfill the request and further calls
will be needed. If \code{maxResults} was provided, it is possible the number
of results to be fewer than \code{maxResults}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of cluster results returned by \code{ListClusters} in
paginated output. When this parameter is used, \code{ListClusters} only
returns \code{maxResults} results in a single page along with a \code{nextToken}
response element. The remaining results of the initial request can be
seen by sending another \code{ListClusters} request with the returned
\code{nextToken} value. This value can be between 1 and 100. If this
parameter is not used, then \code{ListClusters} returns up to 100 results and
a \code{nextToken} value if applicable.}
}
\description{
Returns a list of existing clusters.
}
\section{Request syntax}{
\preformatted{svc$list_clusters(
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
# This example lists all of your available clusters in your default
# region.
\donttest{svc$list_clusters()}

}
\keyword{internal}
